/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Language
implements Serializable {
    private static final long serialVersionUID = 849794032433789267L;
    public String isoName;
    public String natName;
    public String engName;
    public boolean rightToLeft;
    public boolean asianTokenizer;
    public boolean russianTokenizer;
    public Locale locale;
    public ArrayList<String> chartable;
    private static final String UTF8_BOM = "\ufeff";

    public Language(String isoname) {
        this.isoName = isoname;
        this.chartable = null;
        this.natName = null;
        this.engName = null;
        if (isoname == null) {
            return;
        }
        if (isoname.equals("ac")) {
            this.natName = "Acadien";
            this.engName = "Acadian";
            this.locale = new Locale("fr", "CA");
            this.rightToLeft = false;
        } else if (isoname.equals("ar")) {
            this.engName = "Arabic";
            this.locale = new Locale("ar", "SA");
            this.rightToLeft = true;
        } else if (isoname.equals("bg")) {
            this.locale = new Locale("bg", "BG");
            this.rightToLeft = false;
        } else if (isoname.equals("be")) {
            this.locale = new Locale("be", "BY");
            this.rightToLeft = false;
            this.russianTokenizer = true;
        } else if (isoname.equals("ca")) {
            this.locale = new Locale("ca", "ES");
            this.rightToLeft = false;
        } else if (isoname.equals("cz")) {
            this.locale = new Locale("cs", "CZ");
            this.rightToLeft = false;
        } else if (isoname.equals("da")) {
            this.locale = new Locale("da", "DK");
            this.rightToLeft = false;
        } else if (isoname.equals("de")) {
            this.locale = new Locale("de", "DE");
            this.rightToLeft = false;
        } else if (isoname.equals("el")) {
            this.locale = new Locale("el", "GR");
            this.rightToLeft = false;
        } else if (isoname.equals("en")) {
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("fa")) {
            this.locale = new Locale("fa", "IR");
            this.rightToLeft = true;
        } else if (isoname.equals("fi")) {
            this.locale = new Locale("fi", "FI");
            this.rightToLeft = false;
        } else if (isoname.equals("fr")) {
            this.locale = new Locale("fr", "FR");
            this.rightToLeft = false;
        } else if (isoname.equals("gl")) {
            this.natName = "galego";
            this.engName = "Galician";
            this.rightToLeft = false;
        } else if (isoname.equals("he")) {
            this.locale = new Locale("he", "IL");
            this.rightToLeft = true;
        } else if (isoname.equals("hi")) {
            this.locale = new Locale("hi", "IN");
            this.rightToLeft = false;
        } else if (isoname.equals("hr")) {
            this.locale = new Locale("hr", "HR");
            this.rightToLeft = false;
        } else if (isoname.equals("hu")) {
            this.locale = new Locale("hu", "HU");
            this.rightToLeft = false;
        } else if (isoname.equals("hy")) {
            this.locale = new Locale("hy", "AM");
            this.rightToLeft = false;
        } else if (isoname.equals("ma")) {
            this.natName = "kreol morisyen";
            this.engName = "Mauritian";
            this.locale = new Locale("fr", "FR");
            this.rightToLeft = false;
        } else if (isoname.equals("it")) {
            this.locale = new Locale("it", "IT");
            this.rightToLeft = false;
        } else if (isoname.equals("ja")) {
            this.locale = new Locale("ja", "JP");
            this.rightToLeft = false;
            this.asianTokenizer = true;
        } else if (isoname.equals("ko")) {
            this.locale = new Locale("ko", "KR");
            this.rightToLeft = false;
        } else if (isoname.equals("ku")) {
            this.natName = "kurmanc\u00ee";
            this.engName = "Kurdish";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("ks")) {
            this.natName = "Kurdish (sorani dialect)";
            this.engName = "\u06a9\u0648\u0631\u062f\u064a";
            this.locale = new Locale("fa", "IR");
            this.rightToLeft = true;
        } else if (isoname.equals("la")) {
            this.natName = "Lingva Latina";
            this.engName = "Latin";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("mg")) {
            this.natName = "Malagasy";
            this.engName = "Malagasy";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("mk")) {
            this.locale = new Locale("mk", "MK");
            this.rightToLeft = false;
        } else if (isoname.equals("np")) {
            this.natName = "Nimipuu";
            this.engName = "Nez Perce";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("pt")) {
            this.locale = new Locale("pt", "PT");
            this.rightToLeft = false;
        } else if (isoname.equals("ro")) {
            this.locale = new Locale("ro", "RO");
            this.rightToLeft = false;
        } else if (isoname.equals("rr")) {
            this.natName = "Romani";
            this.engName = "Romani";
            this.rightToLeft = false;
        } else if (isoname.equals("ru")) {
            this.locale = new Locale("ru", "RU");
            this.rightToLeft = false;
            this.russianTokenizer = true;
        } else if (isoname.equals("pl")) {
            this.locale = new Locale("pl", "PL");
            this.rightToLeft = false;
        } else if (isoname.equals("qu")) {
            this.natName = "Quechua";
            this.engName = "Quechua";
            this.rightToLeft = false;
        } else if (isoname.equals("sa")) {
            this.locale = new Locale("sa", "IN");
            this.rightToLeft = false;
        } else if (isoname.equals("sy")) {
            this.natName = "Syriac";
            this.engName = "Syriac";
            this.locale = new Locale("ar", "SA");
            this.rightToLeft = true;
        } else if (isoname.equals("sp")) {
            this.locale = new Locale("es", "ES");
            this.rightToLeft = false;
        } else if (isoname.equals("sq")) {
            this.locale = new Locale("sq", "AL");
            this.rightToLeft = false;
        } else if (isoname.equals("sr")) {
            this.locale = new Locale("sr", "RS");
            this.rightToLeft = false;
        } else if (isoname.equals("sw")) {
            this.natName = "Kiswahili";
            this.engName = "Kiswahili";
            this.locale = new Locale("sw", "KE");
            this.rightToLeft = false;
        } else if (isoname.equals("th")) {
            this.locale = new Locale("th", "TH");
            this.rightToLeft = false;
            this.asianTokenizer = true;
        } else if (isoname.equals("tm")) {
            this.natName = "Tamajaq";
            this.engName = "Tamajaq";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("tr")) {
            this.locale = new Locale("tr", "TR");
            this.rightToLeft = false;
        } else if (isoname.equals("uk")) {
            this.locale = new Locale("uk", "UA");
            this.rightToLeft = false;
        } else if (isoname.equals("vi")) {
            this.locale = new Locale("vi", "VN");
            this.rightToLeft = false;
        } else if (isoname.equals("wo")) {
            this.locale = new Locale("wo", "SN");
            this.rightToLeft = false;
        } else if (isoname.equals("zh")) {
            this.locale = new Locale("zh", "TW");
            this.rightToLeft = false;
            this.asianTokenizer = true;
        }
        if (this.natName == null) {
            if (this.locale == null) {
                this.locale = new Locale("en", "US");
                this.natName = "Unknown";
                this.engName = "Unknown";
            } else {
                this.natName = this.locale.getDisplayName(this.locale);
                this.engName = this.locale.getDisplayName(Locale.ENGLISH);
            }
        }
    }

    public static String[] getAllLanguages() {
        ArrayList<String> all = new ArrayList<String>();
        all.add("ac");
        all.add("ar");
        all.add("be");
        all.add("bg");
        all.add("ca");
        all.add("cz");
        all.add("da");
        all.add("de");
        all.add("el");
        all.add("en");
        all.add("fa");
        all.add("fi");
        all.add("fr");
        all.add("gl");
        all.add("he");
        all.add("hr");
        all.add("hi");
        all.add("hu");
        all.add("hy");
        all.add("it");
        all.add("ja");
        all.add("ko");
        all.add("ku");
        all.add("ks");
        all.add("la");
        all.add("mk");
        all.add("ma");
        all.add("mg");
        all.add("np");
        all.add("pl");
        all.add("pt");
        all.add("qu");
        all.add("ro");
        all.add("rr");
        all.add("ru");
        all.add("sa");
        all.add("sy");
        all.add("sp");
        all.add("sq");
        all.add("sr");
        all.add("sw");
        all.add("th");
        all.add("tm");
        all.add("tr");
        all.add("uk");
        all.add("vi");
        all.add("wo");
        all.add("zh");
        return all.toArray(new String[all.size()]);
    }

    public static boolean isALanguage(String isoName) {
        String[] alllanguages = Language.getAllLanguages();
        int index = -1;
        for (int i = 0; i < alllanguages.length; ++i) {
            if (!isoName.equals(alllanguages[i])) continue;
            index = i;
        }
        return index != -1;
    }

    public static boolean isLetter(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        switch (c) {
            case '\u00b7': {
                return true;
            }
            case '\u055c': {
                return true;
            }
            case '\u055e': {
                return true;
            }
            case '\u055b': {
                return true;
            }
            case '\u05b0': {
                return true;
            }
            case '\u05b1': {
                return true;
            }
            case '\u05b2': {
                return true;
            }
            case '\u05b3': {
                return true;
            }
            case '\u05b4': {
                return true;
            }
            case '\u05b5': {
                return true;
            }
            case '\u05b6': {
                return true;
            }
            case '\u05b7': {
                return true;
            }
            case '\u05b8': {
                return true;
            }
            case '\u05c2': {
                return true;
            }
            case '\u05c1': {
                return true;
            }
            case '\u05b9': {
                return true;
            }
            case '\u05bc': {
                return true;
            }
            case '\u05bb': {
                return true;
            }
            case '\u064c': {
                return true;
            }
            case '\u064b': {
                return true;
            }
            case '\u064d': {
                return true;
            }
            case '\u064f': {
                return true;
            }
            case '\u064e': {
                return true;
            }
            case '\u0650': {
                return true;
            }
            case '\u0652': {
                return true;
            }
            case '\u0651': {
                return true;
            }
            case '\u0301': {
                return true;
            }
            case '\u0300': {
                return true;
            }
            case '\u0303': {
                return true;
            }
            case '\u0309': {
                return true;
            }
            case '\u0323': {
                return true;
            }
            case '\u01a0': {
                return true;
            }
            case '\u0901': {
                return true;
            }
            case '\u0902': {
                return true;
            }
            case '\u0903': {
                return true;
            }
            case '\u093c': {
                return true;
            }
            case '\u093e': {
                return true;
            }
            case '\u093f': {
                return true;
            }
            case '\u0940': {
                return true;
            }
            case '\u0941': {
                return true;
            }
            case '\u0942': {
                return true;
            }
            case '\u0943': {
                return true;
            }
            case '\u0945': {
                return true;
            }
            case '\u0947': {
                return true;
            }
            case '\u0948': {
                return true;
            }
            case '\u0949': {
                return true;
            }
            case '\u094b': {
                return true;
            }
            case '\u094c': {
                return true;
            }
            case '\u094d': {
                return true;
            }
            case '\u0341': {
                return true;
            }
            case '\u030c': {
                return true;
            }
        }
        return false;
    }

    public static char finalize(char c) {
        switch (c) {
            case '\u05db': {
                return '\u05da';
            }
            case '\u05de': {
                return '\u05dd';
            }
            case '\u05e0': {
                return '\u05df';
            }
            case '\u05e4': {
                return '\u05e3';
            }
            case '\u05e6': {
                return '\u05e5';
            }
            case '\u05da': {
                return '\u05db';
            }
            case '\u05dd': {
                return '\u05de';
            }
            case '\u05df': {
                return '\u05e0';
            }
            case '\u05e3': {
                return '\u05e4';
            }
            case '\u05e5': {
                return '\u05e6';
            }
        }
        return c;
    }

    public static char toNoAccent(char u) {
        switch (u) {
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c4': {
                return 'A';
            }
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': {
                return 'E';
            }
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': {
                return 'I';
            }
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d6': {
                return 'O';
            }
            case '\u0150': {
                return '\u00d6';
            }
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': {
                return 'U';
            }
            case '\u0170': {
                return '\u00dc';
            }
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e4': {
                return 'a';
            }
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': {
                return 'e';
            }
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': {
                return 'i';
            }
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f6': {
                return 'o';
            }
            case '\u0151': {
                return '\u00f6';
            }
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': {
                return 'u';
            }
            case '\u0171': {
                return '\u00fc';
            }
            case '\u1f08': {
                return '\u0391';
            }
            case '\u1f18': {
                return '\u0395';
            }
            case '\u1f28': {
                return '\u0397';
            }
            case '\u1f38': {
                return '\u0399';
            }
            case '\u1f48': {
                return '\u039f';
            }
            case '\u1f68': {
                return '\u03a9';
            }
            case '\u1f00': {
                return '\u03b1';
            }
            case '\u1f10': {
                return '\u03b5';
            }
            case '\u1f20': {
                return '\u03b7';
            }
            case '\u1f30': {
                return '\u03b9';
            }
            case '\u1f40': {
                return '\u03bf';
            }
            case '\u03cd': {
                return '\u03c5';
            }
            case '\u03ce': {
                return '\u03c9';
            }
            case '\u0390': {
                return '\u03ca';
            }
            case '\u03b0': {
                return '\u03cb';
            }
            case '\u03ca': {
                return '\u03b9';
            }
            case '\u03cb': {
                return '\u03c5';
            }
            case '\u1f09': {
                return '\u0391';
            }
            case '\u1f19': {
                return '\u0395';
            }
            case '\u1f29': {
                return '\u0397';
            }
            case '\u1f39': {
                return '\u0399';
            }
            case '\u1f49': {
                return '\u039f';
            }
            case '\u1fec': {
                return '\u03a1';
            }
            case '\u1f59': {
                return '\u03a5';
            }
            case '\u1f69': {
                return '\u03a9';
            }
            case '\u1f01': {
                return '\u03b1';
            }
            case '\u1f11': {
                return '\u03b5';
            }
            case '\u1f21': {
                return '\u03b7';
            }
            case '\u1f31': {
                return '\u03b9';
            }
            case '\u1f41': {
                return '\u03bf';
            }
            case '\u1fe5': {
                return '\u03c1';
            }
            case '\u1f51': {
                return '\u03c5';
            }
            case '\u1f61': {
                return '\u03c9';
            }
            case '\u1fb6': {
                return '\u03b1';
            }
            case '\u1fc6': {
                return '\u03b7';
            }
            case '\u1fe6': {
                return '\u03c5';
            }
            case '\u1ff6': {
                return '\u03c9';
            }
            case '\u1fcc': {
                return '\u0397';
            }
            case '\u1ffc': {
                return '\u03a9';
            }
            case '\u1fb3': {
                return '\u03b1';
            }
            case '\u1fc3': {
                return '\u03b7';
            }
            case '\u1ff3': {
                return '\u03c9';
            }
            case '\u1f70': {
                return '\u03b1';
            }
            case '\u1f72': {
                return '\u03b5';
            }
            case '\u1f74': {
                return '\u03b7';
            }
            case '\u1f76': {
                return '\u03b9';
            }
            case '\u1f78': {
                return '\u03bf';
            }
            case '\u1f7a': {
                return '\u03c5';
            }
            case '\u1f7c': {
                return '\u03c9';
            }
            case '\u1fba': {
                return '\u0391';
            }
            case '\u1fc8': {
                return '\u0395';
            }
            case '\u1fca': {
                return '\u0397';
            }
            case '\u1fda': {
                return '\u0399';
            }
            case '\u1ff8': {
                return '\u039f';
            }
            case '\u1fea': {
                return '\u03a5';
            }
            case '\u1ffa': {
                return '\u03a9';
            }
            case '\u1f71': {
                return '\u03b1';
            }
            case '\u1f73': {
                return '\u03b5';
            }
            case '\u1f75': {
                return '\u03b7';
            }
            case '\u1f77': {
                return '\u03b9';
            }
            case '\u1f79': {
                return '\u03bf';
            }
            case '\u1f7b': {
                return '\u03c5';
            }
            case '\u1f7d': {
                return '\u03c9';
            }
            case '\u1fbb': {
                return '\u0391';
            }
            case '\u1fc9': {
                return '\u0395';
            }
            case '\u1fcb': {
                return '\u0397';
            }
            case '\u1fdb': {
                return '\u0399';
            }
            case '\u1ff9': {
                return '\u039f';
            }
            case '\u1ffb': {
                return '\u03a9';
            }
            case '\u0451': {
                return '\u0435';
            }
            case '\u0401': {
                return '\u0415';
            }
        }
        return u;
    }

    final ArrayList parseSequenceOfTokens(String sequence) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sequence.length()) {
            int j;
            if (sequence.charAt(i) == '\\') {
                result.add(sequence.substring(i, i + 2));
                i += 2;
                continue;
            }
            if (sequence.charAt(i) == '<') {
                int embeddedAngle = 0;
                j = 1;
                while (i + j < sequence.length() && (sequence.charAt(i + j) != '>' || sequence.charAt(i + j) == '>' && embeddedAngle != 0)) {
                    if (sequence.charAt(i + j) == '<') {
                        ++embeddedAngle;
                    } else if (sequence.charAt(i + j) == '>') {
                        --embeddedAngle;
                    }
                    ++j;
                }
                if (i + j >= sequence.length()) {
                    return null;
                }
                result.add(sequence.substring(i, i + ++j));
                i += j;
                continue;
            }
            if (sequence.charAt(i) == '\"') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '\"') {
                    ++j;
                }
                if (i + j >= sequence.length()) {
                    return null;
                }
                result.add(sequence.substring(i, i + ++j));
                i += j;
                continue;
            }
            if (sequence.charAt(i) == ':') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '#') {
                    ++j;
                }
                if (j < sequence.length()) {
                    result.add(sequence.substring(i, i + ++j));
                } else {
                    result.add(sequence.substring(i));
                }
                i += j;
                continue;
            }
            if (sequence.charAt(i) == '$') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '#') {
                    ++j;
                }
                if (j < sequence.length()) {
                    result.add(sequence.substring(i, i + ++j));
                } else {
                    result.add(sequence.substring(i));
                }
                i += j;
                continue;
            }
            if (Character.isWhitespace(sequence.charAt(i))) {
                ++i;
                continue;
            }
            if (Language.isLetter(sequence.charAt(i))) {
                j = 0;
                while (i + j < sequence.length() && Language.isLetter(sequence.charAt(i + j))) {
                    ++j;
                }
                result.add(sequence.substring(i, i + j));
                i += j;
                continue;
            }
            result.add(String.valueOf(sequence.charAt(i)));
            ++i;
        }
        return result;
    }

    public final int sortTexts(String text1, String text2, boolean ignoreCase) {
        ParameterCheck.mandatory("text1", text1);
        ParameterCheck.mandatory("text2", text2);
        Collator collator = Collator.getInstance(this.locale);
        if (ignoreCase) {
            return collator.compare(text1.toLowerCase(this.locale), text2.toLowerCase(this.locale));
        }
        return collator.compare(text1, text2);
    }
}

